class Ex11_20
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=2"mass of the disk";
parameter Real R(unit="m")=150/(2*1000)"radius of the disk";
parameter Real h(unit="m")=250/1000"length of disk and y-axis";
parameter Real w(unit="rad/s")=4800*((2*pi)/60)"angular velocity of disk";
parameter Real theta(unit="rad")=20*(pi/180)"angular position of the disk";
Real I_z(unit="kg.m^2")"moment of inertia about z";
Real I_y(unit="kg.m^2")"moment of inertia about y";
Real beta_dot_steady(unit="rad/s")=-1.735"steady state processional angular velocity";
Real beta_dot(unit="rad/s")"processional angular velocity";
Real error(unit="%")"error in processional angular velocity";
equation
I_z=(1/2)*m*R^2;
I_y=(m*R^2)/4+m*h^2;
beta_dot^2*cos(theta)*(I_z-I_y)-beta_dot*w*I_z=m*g*h;
error=((abs(beta_dot)-abs(beta_dot_steady))/abs(beta_dot))*100;
end Ex11_20;
