class Ex12_1
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=4"mass of the element";
parameter Real k(unit="N/m")=800"spring constant";
parameter Real x_0(unit="m")=0.05"initial position";
parameter Real x_0_dot(unit="m/s")=-0.75"initial velocity";
parameter Real t_0(unit="s")=0"starting time";
Real w_n(unit="rad/s")"angular velocity";
Real T(unit="s")"time period";
Real f(unit="Hz")"frequency";
Real A(unit="m",start=0.05)"amplitude";
Real phi(unit="rad",start=-0.5)"phase of x";
Real v_max(unit="m/s")"maximum velocity";
Real a_max(unit="m/s^2")"maximum acceleration";
equation
w_n^2=400;
T=(2*pi)/w_n;
f=1/T;
x_0=A*cos(w_n*t_0-phi);
x_0_dot=-20*A*sin(w_n*t_0-phi);
v_max=A*w_n;
a_max=A*w_n^2;
end Ex12_1;
