class Ex8_19
parameter Real pi=Modelica.Constants.pi;
parameter Real z_dot_mag(unit="m/s")=180*((1.852*10^3)/3600)"magnitude of the z-component of the velocity of the tip";
Real z_dot[3](each unit="m/s")"z-component of the velocity of the tip";
parameter Real r(unit="m")=4/2"radius of the propeller";
parameter Real theta_dot(unit="rad/s")=1035*((2*pi)/60)"angular velocity of the blade";

Real v_T(unit="m/s")"magnitude of the transverse component of the tip velocity";
Real v[3](each unit="m/s")"velocity of the tip of the propeller";
Real v_st[3](each unit="m/s")"velocity of the south tip of the propeller";
Real a[3](each unit="m/s^2")"acceleration of the tip of the propeller";
Real a_st[3](each unit="m/s")"acceleration of the south tip of the propeller";
equation
z_dot={0,0,z_dot_mag};
v_T=r*theta_dot;
v={0,v_T,z_dot[3]};
v_st={-v[2],0,v[3]};
a={-r*theta_dot^2,0,0};
a_st={0,a[1],0};
/*The  answer may slightly vary due to  rounding off values*/
end Ex8_19;
