class Ex9_2
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=0.15"mass of the pilot";
parameter Real r(unit="m")=1"radius of the circular path";
parameter Real w(unit="rad/s")=25*((2*pi)/60)"angular velocity of the OA";

Real a_n(unit="m/s^2")"n-component of the acceleration";
Real a_t(unit="m/s^2")"t-component of the acceleration";
parameter Real a_z(unit="m/s^2")=0"z-component of the acceleration";
Real T(unit="N",start=1)"manitude of the tension in the cord";
Real phi(unit="rad")"angle phi in radian unit";
Real phi_deg(unit="deg")"angle phi in degree unit";
Real R_L[3](each unit="N")"left hand side of the equation of motion";
Real R_R[3](each unit="N")"right hand side of the equation of motion";
equation
R_L={T*sin(phi),0,T*cos(phi)-m*g};
R_R=m*{a_n,a_t,a_z};
a_n=r*w^2;

R_L[1]=R_R[1];
R_L[2]=R_R[2];
R_L[3]=R_R[3];

phi_deg=Modelica.SIunits.Conversions.to_deg(phi);
end Ex9_2;
