class Ex9_7
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=1000"mass of the body";
parameter Real l(unit="m")=1.5"length of the body";
parameter Real w(unit="m")=1"width of the body";
parameter Real h(unit="m")=2"height of the body";
parameter Real d(unit="m")=0.25"vertical distance between C and D";

Real W[3](each unit="N")"weight of the body";
Real a_x(unit="m/s^2")"x-component of the acceleration of the assembly";
Real a[3](each unit="m/s^2")"acceleration of the assembly";
parameter Real T_mag(unit="N")=20*10^3"mangitude of the tensile force";
Real T[3](each unit="N")"tensile force";
Real theta(unit="rad")"direction of the tensile force w.r.t horizontal";
Real C_x(unit="N")"x-component of the reaction force at C";
Real C_z(unit="N")"z-component of the reaction force at C";
Real F_C[3](each unit="N")"reaction force at C";
Real D_x(unit="N")"x-component of the reaction force at D";
Real D_z(unit="N")"z-component of the reaction force at D";
Real F_D[3](each unit="N")"reaction force at D";

Real r_C[3](each unit="m")"position of C w.r.t. G";
Real r_D[3](each unit="m")"position of D w.r.t. G";
Real r_E[3](each unit="m")"position of E w.r.t. G";


Real F_L[3](each unit="N")"left hand side of the equation of motion";
Real F_R[3](each unit="N")"right hand side of the equation of motion";

Real M_L[3](each unit="N")"left hand side of the equation of moment";
Real M_R[3](each unit="N")"right hand side of the equation of moment";
equation
W={0,0,-m*g};
a={a_x,0,0};
theta=atan(4/3);
T=T_mag*{cos(theta),0,-sin(theta)};
F_C={C_x,0,C_z};
F_D={D_x,0,D_z};
r_C={l/2,w/2,-h/2};
r_D={l/2,-w/2,-h/2};
r_E={l/2,-w/2,h/2};

F_L=T+F_C+F_D+W;
F_R=m*a;
F_L[1]=F_R[1];
F_L[3]=F_R[3];
M_L=cross(r_C,F_C)+cross(r_D,F_D)+cross(r_E,T);
M_R={0,0,0};
M_L[1]=M_R[1];
M_L[2]=M_R[2];
M_L[3]=M_R[3];
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_7;
