class Ex10_2
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m_A(unit="kg")=100"mass of the body A";
parameter Real m_B(unit="kg")=150"mass of the body B";
parameter Real k(unit="N/m")=300"spring constant";
parameter Real dx(unit="m")=2"unstressed length of the spring";
parameter Real dx_1(unit="m")=1.5"initial stressed length of the spring";
parameter Real ds(unit="m")=3.6"displacement of the body";
parameter Real F(unit="N")=450"applied force";

Real U_A(unit="J")"work done by A";
Real U_B(unit="J")"work done by B";
Real U_F(unit="J")"work done by force F";
Real U_spring(unit="J")"work done by the spring force";
Real U(unit="J")"total work done";
equation
U_A=m_A*g*0.8*ds;
U_B=m_B*g*ds;
U_F=sum((450*{0.6,0.8}).*(ds*{0.6,-0.8}));
U_spring=((k*(dx-dx_1))*(dx-dx_1))/2-(k*1.9*1.9)/2;
U=U_A+U_B+U_F+U_spring;
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_2;
