class Ex10_3
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=10"mass of the body";
parameter Real k(unit="N/m")=500"spring constant";
parameter Real l_1(unit="m")=16"length of the spring at position A";
Real l_2(unit="m")"length of the spring at position A_das";
Real dx_1(unit="m")=4"stressed length of the spring at position A";
Real dx_2(unit="m")"stressed length of the spring at position A_das";
parameter Real AA_das_V(unit="m")=4"vertical distance between A and A_das";
parameter Real AA_das_H(unit="m")=5"horizontal distance between A and A_das";
Real U_spring(unit="J")"work done on the body by the spring";
Real U_wt(unit="J")"work done on the body by the weight";
Real U(unit="J")"total work done";
parameter Real v_i(unit="m/s")=10"velocity of the body at position A";
Real v_f(unit="m/s")"velocity of the body at position A_das";
equation
l_2=sqrt((l_1-AA_das_V)^2+AA_das_H^2);
dx_2=l_2-(l_1-dx_1);
U_spring=-250*(dx_2^2-dx_1^2);
U_wt=-m*g*AA_das_V;
U=U_spring+U_wt;
U=(1/2)*m*(v_f^2-v_i^2);
end Ex10_3;
