class Ex10_8
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m_A(unit="kg")=10"mass of the wheel A";
parameter Real m_B(unit="kg")=25"mass of the block B";
parameter Real mu(unit="N/m")=0.3"coefficient of friction";
parameter Real d(unit="m")=3"distance traveled by A";
parameter Real theta_A(unit="rad")=30*(pi/180)"inclination of the plane E";
parameter Real theta_B(unit="rad")=60*(pi/180)"inclination of the plane H";
Real N_2(unit="N")"normal force on B";
Real F_2[2](each unit="N")"friciton force on B";
Real U_F2(unit="J")"work done by F_2";
Real U_10g(unit="J")"work done by the weight of A";
Real U_25g(unit="J")"work done by the weight of B";
Real U(unit="J")"total work done";
equation
N_2-m_B*g*cos(theta_B)=0;
F_2={0,mu*N_2};
U_F2=sum(F_2.*{0,-d});
U_10g=sum({-m_A*g*sin(theta_A),-m_A*g*cos(theta_A)}.*{d,0});
U_25g=sum({-m_B*g*sin(theta_A),-m_B*g*cos(theta_A)}.*{0,-d});
U=U_F2+U_10g+U_25g;
end Ex10_8;
