class Ex11_17
parameter Real m(unit="kg")=20"mass of the bar";
parameter Real AC(unit="m")=1.6"length of AC";
parameter Real BC(unit="m")=0.4"length of BC";
Real r_G(unit="m")"distance between cg and C";
parameter Real v_Gi(unit="m/s")=10"initial velocity of the bar";
Real I_AR(unit="kg.m^2")"moment of inertia";
Real w_f(unit="rad/s")"angular velocity of the bar immediately after impact";
Real T_i(unit="J")"kinetic energy before impact";
Real T_f(unit="J")"kinetic energy just after impact";
Real T_loss(unit="J")"loss of kinetic energy";
Real C_x(unit="N")"horizontal component of the reaction of the bearing";
equation
r_G=((AC+BC)/2)-BC;
I_AR=(1/12)*m*(AC+BC)^2+m*r_G^2;
m*v_Gi*r_G=I_AR*w_f;
T_i=(1/2)*m*v_Gi^2;
T_f=(1/2)*I_AR*w_f^2;
T_loss=T_i-T_f;
C_x=m*r_G*w_f^2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex11_17;
