class Ex11_19
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=2"mass of the disk";
parameter Real r(unit="m")=150/(2*1000)"radius of the disk";
parameter Real l(unit="m")=250/1000"length of disk and y-axis";
parameter Real w_z[3](each unit="rad/s")={0,0,-4800*((2*pi)/60)}"angular velocity of disk w.r.t z-axis";
Real M_0[3](each unit="N.m")"moment about O";
Real H_z[3](each unit="N.m.s")"z-component of angular momentum";
Real I_z(unit="kg.m^2")"moment of inertia about z";
Real w_y(unit="rad/s")"angular velocity of disk w.r.t y-axis";
Real H_z_dot[3](each unit="N.m")"1st derivative of the z-component of angular momentum";
equation
M_0={l*m*g,0,0};
I_z=(1/2)*m*r^2;
H_z=w_z*I_z;
H_z_dot=H_z[3]*cross({0,w_y,0},{0,0,1});
H_z_dot[1]=M_0[1];
end Ex11_19;
