class Ex11_3
parameter Real pi=Modelica.Constants.pi;
parameter Real A_J(unit="m^2")=10*10^(-4)"cross sectional area of the jet";
parameter Real v_J(unit="m/s")=60"velocity of the jet";
parameter Real v_B(unit="m/s")=25"velocity of the blade";
parameter Real rho(unit="kg/m^3")=10^6*10^(-3)"density of the water";
parameter Real theta(unit="rad")=30*(pi/180)"output angle of the jet";
Real m(unit="kg")"mass of the water";
Real v_JB_das[2](each unit="m/s")"velocity of the jet relative to the blade before impact";
Real v_JB_ddas[2](each unit="m/s")"final relative velocity";
Real v_J_ddas[2](each unit="m/s")"final absolute velocity of the jet";
Real R_w[2](each unit="N")"resultant force on water";
Real R[2](each unit="N")"resultant force on the blade ";
Real P(unit="W")"developed power";
parameter Real dt(unit="s")=1"time-Assuming";
equation
m=A_J*(v_J-v_B)*dt*rho;
v_JB_das={-v_J-(-v_B),0};
v_JB_ddas=abs(v_JB_das[1])*{cos(theta),sin(theta)};
v_J_ddas={-v_B,0}+v_JB_ddas;
R_w*dt=m*(v_J_ddas-{-v_J,0});
R=-R_w;
P=R_w[1]*v_B;
/*The  answer may slightly vary due to  rounding off values*/
end Ex11_3;
