class Ex11_6
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m_A(unit="kg")=100/1000"mass of A";
parameter Real m_B(unit="kg")=100/1000"mass of B";
parameter Real e=0.56"coeffciecnt of restitution";

parameter Real v_Ai(unit="m/s")=12"initial velocity of A";
parameter Real theta(unit="rad")=30*(pi/180)"direction of v_Ai";
Real v_Axi(unit="m/s")"initial velocity of A in x-direction";
Real v_Ayi(unit="m/s")"initial velocity of A in y-direction";
Real v_Axf(unit="m/s")"final velocity of A in x-direction";
Real v_Ayf(unit="m/s")"final velocity of A in y-direction";

parameter Real v_Bxi(unit="m/s")=-15"initial velocity of B in x-direction";
parameter Real v_Byi(unit="m/s")=0"initial velocity of B in y-direction";
Real v_Bxf(unit="m/s")"final velocity of B in x-direction";
Real v_Byf(unit="m/s")"final velocity of B in y-direction";

Real v_Af[2](each unit="m/s")"final velocity of A";
Real theta_Af(unit="deg")"direction of v_Af";
Real v_Bf[2](each unit="m/s")"final velocity of B";
equation
v_Axi=v_Ai*cos(theta);
v_Ayi=v_Ai*sin(theta);
v_Ayf=v_Ayi;
v_Byf=v_Byi;

m_A*v_Axi+m_B*v_Bxi=m_A*v_Axf+m_B*v_Bxf;
e=-(v_Axf-v_Bxf)/(v_Axi-v_Bxi);
v_Af={v_Axf,v_Ayf};
v_Bf={v_Bxf,v_Byf};
theta_Af=(atan(v_Ayf/abs(v_Axf)))*(180/pi);
end Ex11_6;
