class Ex12_5
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real k(unit="N/m")=2*12*10^3"spring constant";
parameter Real c(unit="N.s/m")=160"daspot coefficien";
parameter Real m(unit="kg")=20"unblance mass";
parameter Real m_B(unit="kg")=0.5"unblance body mass";
parameter Real e(unit="m")=75/1000"location of the body";
parameter Real w(unit="rad/s")=300*((2*pi)/60)"rotational speed of motor";
Real F_0(unit="N")"amplitude of the force";
Real A(unit="m",start=0.001)"amplitude of the motion";
Real phi(unit="deg")"phase angle of the motion";
Real F_sp_max(unit="N")"maximum force exerted by spring";
Real F_sp_min(unit="N")"minimum force exerted by spring";
Real F_d_max(unit="N")"maximum force exerted by damper";
Real F_v(unit="N")"amplitude of the resultant variable force";
Real F_max(unit="N")"maximum resultant force exerted by spring and damper";
Real F_min(unit="N")"minimum resultant force exerted by spring and damper";
Real w_r(unit="rad/s")"resonant velocity";
Real A_r(unit="m")"amplitude of resonant";
equation
F_0=m_B*e*w^2;
(37/A)^2=(k-m*w^2)^2+(c*w)^2;
phi=atan((c*w)/4280)*(180/pi);
F_sp_max=m*g+k*A;
F_sp_min=m*g-k*A;
F_d_max=c*A*w;
F_v=sqrt(134.4^2+F_d_max^2);
F_max=196.2+F_v;
F_min=196.2-F_v;
w_r=sqrt(k/m);
A_r=(m_B*e*w_r)/c;
/*The  answer may slightly vary due to  rounding off values*/
end Ex12_5;
