class Ex12_6
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real k(unit="N/m")=12*10^3"spring constant";
parameter Real c(unit="N.s/m")=100"damper coefficien";
parameter Real m(unit="kg")=10"mass of the body";
parameter Real e(unit="m")=12/1000"length of the crank";
parameter Real w(unit="rad/s")=40"rotational speed of crank";
Real F_0(unit="N")"amplitude of the force";
Real A(unit="m",start=0.001)"amplitude of the motion";
Real phi(unit="deg")"phase angle of the motion";
Real t(unit="s")"time";
Real A_dis(unit="m",start=0.001)"amplitude of the motion with disconnected damper";
equation
F_0=e*k;
(144/A)^2=(m*w^2-k)^2+4800^2;
phi=90-atan((c*w)/(-c*w))*(180/pi);
t=(phi*(pi/180))/w;
144/A_dis=m*w^2-k;
/*The  answer may slightly vary due to  rounding off values*/

end Ex12_6;
