class Ex8_12
parameter Real pi=Modelica.Constants.pi;
parameter Real w(unit="km")=2"width of the river";
parameter Real l(unit="km")=1"distance between A and C along y-direction";

parameter Real v_bw(unit="km/h")=20"magnitude of the velocity of the wr.t. water";
parameter Real v_w[2](each unit="km/h")=8*{0,-1}"velocity of the water";
Real v_B(unit="km/h")"magnitude of the absolute velocity of the boat";

Real theta_1(unit="rad")"angle of the absolute velocity of the boat";
Real theta_2(unit="rad")"angle of the raletive velocity of the boat";
Real theta_3(unit="rad")"angle of the raletive velocity of the boat east of due north in radian unit";
Real theta_3_deg(unit="deg")"angle of the raletive velocity of the boat east of due north in degree unit";

Real v_B_L[2](each unit="km/h")"left hand side of the velocity equation of the boat";
Real v_B_R[2](each unit="km/h")"right hand side of the velocity equation of the boat";
Real dt(unit="h")"required time to reach C from A";
equation
theta_1=atan(l/w);
v_B_L=v_B*{cos(theta_1),sin(theta_1)};
v_B_R=v_w+v_bw*{cos(theta_2),sin(theta_2)};
v_B_L[1]=v_B_R[1];
v_B_L[2]=v_B_R[2];
dt=sqrt(w^2+l^1)/v_B;
theta_3=pi/2-theta_2;
theta_3_deg=Modelica.SIunits.Conversions.to_deg(theta_3);
/*The  answer may slightly vary due to  rounding off values*/
end Ex8_12;
