class Ex8_27
parameter Real v_0(unit="m/s")=4"velocity of the center O";
parameter Real a_0(unit="m/s^2")=10"acceleration of the center O";
parameter Real r(unit="m")=1.6/2"radius of the wheel";
Real w(unit="rad/s")"angular velocity of the wheel";
Real alpha(unit="rad/s^2")"angular acceleration of the wheel";

parameter Real theta_deg(unit="deg")=30"inclination of the OG w.r.t horinzontal in degree unit";
Real theta(unit="rad")"inclination of the OG w.r.t horinzontal in radian unit";
parameter Real OG(unit="m")=0.1"distance between O and G";
Real l_1(unit="m")"horizontal distance between O and G";
Real l_2(unit="m")"vertical distance between O and G";
Real l_3(unit="m")"vertical distance between P and G";
Real r_PG(unit="m")"distance between O and G";

Real v_G(unit="m/s")"velocity of G";
Real a_G[2](each unit="m/s^2")"acceleration of G";
Real a_G_mag(unit="m/s^2")"mangitude of the acceleration of G";
Real theta_1(unit="rad")"direction of the acceleration in radian unit";
Real theta_1_deg(unit="deg")"direction of the acceleration in degree unit";

equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
w=v_0/r;
alpha=a_0/r;

l_1=OG*cos(theta);
l_2=OG*sin(theta);
l_3=r-l_2;
r_PG=sqrt(l_1^2+l_3^2);
v_G=r_PG*w;
a_G={-a_0,0}+alpha*OG*{sin(theta),cos(theta)}+w^2*OG*{-cos(theta),sin(theta)};
a_G_mag=Modelica.Math.Vectors.norm(a_G);
theta_1=atan(a_G[2]/abs(a_G[1]));
theta_1_deg=Modelica.SIunits.Conversions.to_deg(theta_1);
end Ex8_27;
