class Ex9_14
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=30"mass of the bar";
parameter Real w(unit="rad/s")=50*((2*pi)/60)"angular velocity of the bar";
parameter Real BC(unit="m")=200/1000"length of BC";
parameter Real CE(unit="m")=1000/1000"length of CE";
parameter Real DE(unit="m")=800/1000"length of DE";
parameter Real CD(unit="m")=600/1000"length of CD";
Real a_G[3](each unit="m/s^2")"acceleration of the mass center";
Real F_ref[3](each unit="N")"reversed effective force";
Real I_z(unit="kg.m^2")"moment of inertia";
Real I_xz(unit="kg.m^2")"product of inertia";
Real C_R[3](each unit="N.m")"reversed effective couple";
Real E_z(unit="N")"z-component of the raction at E";
Real E_x(unit="N")"x-component of the raction at E";
Real E[3](each unit="N")"raction at E";
Real T_i(unit="N")"i-component of the tension in the cord";
Real T[3](each unit="N")"tension in the cord";
equation
a_G={-(CD/CE)*((BC+CE)/2)*w^2,0,0};
F_ref=-m*a_G;
I_z=0.12*m*(BC+CE)^2;
I_xz=0.04*m*(BC+CE)^2;
C_R={0,w^2*1.728,0};
E_z-m*g=0;
DE*T_i+DE*(CD/CE)*F_ref[1]+((BC+CE)/2)*(CD/CE)*m*g+C_R[2]=0;
E_x+F_ref[1]+T_i=0;
E={E_x,0,E_z};
T={T_i,0,0};

end Ex9_14;
