class Ex9_8
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m_A(unit="kg")=30"mass of the wheel A";
parameter Real r_A(unit="m")=400/(2*1000)"radius of A";
parameter Real k_z(unit="m")=150/1000"radius of gyration";
parameter Real m_B(unit="kg")=20"mass of the body B";
parameter Real M_oz(unit="N.m")=35"applied moment";
parameter Real w(unit="rad/s")=-6"angular velocity of A";
parameter Real r_G(unit="m")=100/1000"length of OG";
Real O_x(unit="N")"x-component of reaction";
Real O_y(unit="N")"y-component of reaction";
Real alpha(unit="rad/s^2")"angular acceleration of A";
Real T(unit="N")"tension in wire";
Real a_By(unit="m/s^2")"acceleration of B";
equation
O_x-0.60*T-0.80*m_A*g=-m_A*r_G*w^2;
O_y-0.80*T+0.60*m_A*g=m_A*r_G*alpha;
M_oz+m_A*g*r_G*cos(atan(4/3))-T*r_A=m_A*k_z^2*alpha;
T-m_B*g=m_B*a_By;
a_By=r_A*alpha;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_8;
