class Ex9_9
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=36"mass of the body";
parameter Real w(unit="rad/s")=4"angular velocity of the plate";
parameter Real alpha(unit="rad/s^2")=6"angular acceleration of the plate";
parameter Real a(unit="m")=1500/1000"base length of the plate";
parameter Real b(unit="m")=900/1000"height of the plate";
parameter Real d(unit="m")=300/1000"distance between A and C";
parameter Real l(unit="m")=300/1000"distance between plate and B";

Real W[3](each unit="N")"weight of the body";
Real I_z(unit="kg.m^2")"moment of inertia about z axis";
Real I_xz(unit="kg.m^2")"moment of inertia in xz plane";
Real a_G[3](each unit="m/s^2")"acceleration of the plate";

Real T_k(unit="N.m")"k-component of the applied torque";
Real T[3](each unit="N.m")"applied torque";
Real B_x(unit="N")"x-component of the reaction force at B";
Real B_y(unit="N")"z-component of the reaction force at B";
Real F_B[3](each unit="N")"reaction force at B";
Real C_x(unit="N")"x-component of the reaction force at C";
Real C_y(unit="N")"y-component of the reaction force at C";
Real F_C[3](each unit="N")"reaction force at C";

Real r_B[3](each unit="m")"position of B";
Real r_C[3](each unit="m")"position of C";
Real r_G[3](each unit="m")"position of G";

Real F_L[3](each unit="N")"left hand side of the equation of motion";
Real F_R[3](each unit="N")"right hand side of the equation of motion";

Real M_L[3](each unit="N")"left hand side of the equation of moment";
Real M_R[3](each unit="N")"right hand side of the equation of moment";
equation
r_B={0,0,1.3};
r_C={0,0,-0.8};
r_G={0.30,0,0};

W={-m*g,0,0};
I_z=m*((2*b^2+3*0^2)/36)+m*d^2;
I_xz=-(m*a*b)/36+m*(b/3)*0;
a_G={-r_G[1]*w^2,r_G[1]*alpha,0};

F_B={B_x,B_y,0};
F_C={C_x,C_y,0};
T={0,0,T_k};

F_L=F_B+F_C+W;
F_R=m*a_G;
F_L[1]=F_R[1];
F_L[2]=F_R[2];
M_L=cross(r_B,F_B)+cross(r_C,F_C)+cross(r_G,W)+T;
M_R={-alpha*I_xz,-w^2*I_xz,alpha*I_z};
M_L[1]=M_R[1];
M_L[2]=M_R[2];
M_L[3]=M_R[3];
/*The  answer may slightly vary due to  rounding off values*/

end Ex9_9;
