class Ex8_16
/*Stop Time should be taken exactly 2.5 second to get result*/
parameter Real r(unit="mm")=3.20*10^3"radius of the path";
Real s(unit="mm")"position of the particle";
Real v(unit="mm/s")"velocity of the particle";
Real a_t(unit="mm/s^2")"t-component of the acceleration of the particle";

Real v_2(unit="mm/s")"velocity of the particle at 2 second";
Real a_2[2](each unit="mm/s^2")"acceleration of the particle at 2 second";
Real a_2_mag(unit="mm/s^2")"magnitude of the acceleration of the particle at 2 second";
Real a_n_2(unit="mm/s^2")"n-component of the acceleration of the particle at 2 second";
Real a_t_2(unit="mm/s^2")"t-component of the acceleration of the particle at 2 second";

Real theta(unit="rad")"direction of the acceleration in radian unit at 2 second"; 
Real theta_deg(unit="deg")"direction of the acceleration in degree unit at 2 second";
equation
s=300*time^2+400*time;
v=der(s);
a_t=der(v);

when time<=2+0.001 and time>=2-0.001 then 
v_2=v;
a_n_2=v_2^2/r;
a_t_2=a_t;
a_2={a_n_2,a_t_2};
a_2_mag=sqrt(a_n_2^2+a_t_2^2);
theta=atan(a_n_2/a_t_2);
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);
end when;
end Ex8_16;
