class Ex8_3
/*Stop Time should be taken exactly 3 second to get result*/

/*Number-b*/
parameter Real s_0(unit="m")=20"initial position of the particle";
parameter Real v_0(unit="m/s")=10"initial velocity of the particle";
parameter Real k(unit="s^(-1)")=0.2"given constant";

Real s(unit="m")"position of the particle";
Real v(unit="m/s")"velocity of the particle";
Real a(unit="m/s^2")"acceleration of the particle";

Real t(unit="s")"required time for s=0 meter";
Real v_s0(unit="m/s")"velocity of the particle at s=0 meter";
Real a_s0(unit="m/s^2")"acceleration of the particle at s=0 meter";
equation
s=-s_0+(v_0/k)*(1-exp(-k*time));
v=v_0*exp(-k*time);
a=-v_0*k*exp(-k*time);

when s<=0+0.02 and s>=0-0.02 then
t=time;
v_s0=v;
a_s0=a;
end when;

end Ex8_3;
