class Ex8_4
/*Number-b*/
parameter Real pi=Modelica.Constants.pi;
parameter Real b(unit="m")=40"given distance";
parameter Real w(unit="rad/s")=5*((2*pi)/60)"angular velocity of the beam";
parameter Real theta_deg(unit="deg")=20"given angular position of the beam in degree unit";
Real theta(unit="rad")"given angular position of the beam in radian unit";
Real v_P(unit="m/s")"velocity of P at theta_deg=20 degree"; 
Real a_P(unit="m/s^2")"acceleration of P at theta_deg=20 degree";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
v_P=b*w*(1/(cos(theta))^2);
a_P=2*b*w^2*(1/(cos(theta))^2)*tan(theta);
end Ex8_4;
