class Ex9_6
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=60"mass of the box";
parameter Real l(unit="m")=2"length of the box";
parameter Real d(unit="m")=0.3"vertical distance between top of the body and the applied force";
parameter Real mu=0.20"coefficient of friction";
parameter Real a(unit="m/s^2")=2"acceleration of the box";
Real P(unit="N")"applied force";
Real F(unit="N")"frictional force";
Real N(unit="N")"normal force on the box";
Real x(unit="m")"acting point of N";

Real R_L[2](each unit="N")"left hand side of the equation of motion";
Real R_R[2](each unit="N")"right hand side of the equation of motion";
equation
R_L={P-F,N-m*g};
R_R=m*{a,0};
R_L[1]=R_R[1];
R_L[2]=R_R[2];
F=mu*N;
x*N-(l/2-d)*P-(l/2)*F=0;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_6;
