class Ex10_7
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=10"mass of the bar";
parameter Real k(unit="N/m")=800"spring constant";
parameter Real P_1(unit="N")=-100"applied force";
parameter Real P_2(unit="N")=100"applied force";
parameter Real d(unit="m")=75/1000"distance between applied force";
Real M(unit="N.m")"generated couple";
Real theta(unit="rad")=(pi/2)"rotatio of the bar";
parameter Real AB(unit="m")=300/1000"length of the bar";
parameter Real l_0(unit="m")=175/1000"unstressed length of the spring";
parameter Real l_1(unit="m")=125/1000"length of the spring at position A";
Real l_2(unit="m")"length of the spring at position A_das";
Real s_i(unit="m")"stressed length of the spring at position A";
Real s_f(unit="m")"stressed length of the spring at position A_das";

Real U_spring(unit="J")"work of the spring on AB";
Real U_weight(unit="J")"work done by the weight";
Real U_couple(unit="J")"work done by the couple";
Real U(unit="J")"total work done on AB";
equation
l_2=sqrt(AB^2+l_1^2);
s_i=l_1-l_0;
s_f=l_2-l_0;
U_spring=((k*abs(s_i))*abs(s_i))/2-((k*s_f)*s_f)/2;
U_weight=m*g*(AB/2);
M=P_2*d;
U_couple=M*theta;
U=U_spring+U_weight+U_couple;
end Ex10_7;
