class Ex10_9
parameter Real m_AC(unit="kg")=20"mass of the bar AC";
parameter Real m_B(unit="kg")=50"mass of the body B";
parameter Real L(unit="m")=2"length of the bar AC";
parameter Real BG(unit="m")=0.4"distance between G and B";
parameter Real k_G(unit="m")=0.50"radius of gyration of the body B";
parameter Real w_AC(unit="rad/s")=2"angular velocity of AC";
parameter Real w_B(unit="rad/s")=5"angular velocity of body B";
Real v_G(unit="m/s")"velocity of G";
Real T_AC(unit="J")"kinetic energy of AC";
Real T_B(unit="J")"kinetic energy of B";
Real T(unit="J")"kinetic energy of the system";
equation
v_G=sqrt((w_AC*L)^2+(w_B*BG)^2);
T_AC=(1/2)*((1/3)*m_AC*L^2)*w_AC^2;
T_B=(1/2)*m_B*v_G^2+(1/2)*(m_B*k_G^2)*w_B^2;
T=T_AC+T_B;

end Ex10_9;
