class Ex11_21
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=100"mass of the element";
parameter Real w_z(unit="rad/s")=12000*((2*pi)/60)"angular velocity of element";
parameter Real k(unit="m")=225/1000"radius of the gyration";
parameter Real R(unit="m")=1200"turn radius";
parameter Real v(unit="m/s")=(750*1000)/3600"forword speed of the plane";
parameter Real GB[3](each unit="m")={0,0,-600/1000}"position of the B w.r.t G";
parameter Real GA[3](each unit="m")={0,0,600/1000}"position of the A w.r.t G";
Real beta_dot[3](unit="rad/s")"processional angular velocity";
Real a_G[3](each unit="m/s^2")"acceleration of the mass center";
Real I_z(unit="kg.m^2")"moment of inertia about z";
Real H_z[3](each unit="N.m.s")"z-component of angular momentum";
Real H_z_dot[3](each unit="N.m")"1st derivative of the z-component of angular momentum";
Real M_G[3](each unit="N.m")"moment about G";
Real A_x(unit="N")"x-component of the reaction at A";
Real A_y(unit="N")"y-component of the reaction at A";
Real B_x(unit="N")"x-component of the reaction at B";
Real B_y(unit="N")"y-component of the reaction at B";
Real A[3](each unit="N")"reaction at A";
Real B[3](each unit="N")"reaction at B";
Real F_left[3](each unit="N")"left side of force equation";
Real F_right[3](each unit="N")"right side of force equation";
equation
beta_dot={0,v/R,0};
a_G={v^2/R,0,0};
I_z=m*k^2;
H_z={0,0,w_z*I_z};
H_z_dot=H_z[3]*cross({0,beta_dot[2],0},{0,0,1});
A={A_x,A_y,0};
B={B_x,B_y,0};
M_G=cross(GA,A)+cross(GB,B);
H_z_dot[1]=M_G[1];
H_z_dot[2]=M_G[2];

F_left=A+B-{0,m*g,0};
F_right=m*a_G;
F_left[1]=F_right[1];
F_left[2]=F_right[2];
end Ex11_21;
