class Ex12_2
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m_rod(unit="kg")=4"mass of the rod";
parameter Real m_body(unit="kg")=2.25"mass of the body";
parameter Real BE(unit="m")=100/1000"length of BE";
parameter Real EC(unit="m")=50/1000"length of EC";
parameter Real k(unit="N/m")=1400"spring constant";
parameter Real theta_0(unit="rad")=(8*pi)/180"initial position";
parameter Real theta_0_dot(unit="rad/s")=0"initial angular velocity";
parameter Real t_0(unit="s")=0"starting time";
Real w_n(unit="rad/s")"angular velocity";
Real T_0(unit="s")"tension in spring";
Real A(unit="rad",start=0.05)"amplitude";
Real phi(unit="rad",start=0.5)"phase of x";
Real theta_dot_max(unit="rad/s")"maximum angular velocity";

equation
(BE+EC)*T_0=((BE+EC)/2)*m_rod*g+BE*m_body*g;
w_n^2=600;
theta_0=A*cos(w_n*t_0-phi);
theta_0_dot=-A*w_n*sin(w_n*t_0-phi);
theta_dot_max=A*w_n;

end Ex12_2;
