class Ex8_18
/*Number-b*/
parameter Real b(unit="cm")=3"constant";
parameter Real c(unit="cm")=2"constant";
parameter Real theta_deg(unit="deg")=90"given position of the pin A in degree unit";
Real theta(unit="rad")"given position of the pin A in radian unit";
parameter Real theta_dot(unit="rad/s")=5"angular velocity of the pin A";
parameter Real theta_ddot(unit="rad/s^2")=-20"angular acceleration of the pin A";

Real r(unit="cm")"position of the pin A";
Real r_dot(unit="cm/s")"1st derivative of r";
Real r_ddot(unit="cm/s")"2nd derivative of r";

Real v[2](each unit="m/s")"velocity of the pin A";
Real theta_1(unit="rad")"direction of the velocity in radian unit"; 
Real theta_1_deg(unit="rad")"direction of the velocity in degree unit"; 

Real a[2](each unit="m/s^2")"acceleration of the pin A";
Real theta_2(unit="rad")"direction of the acceleration in radian unit"; 
Real theta_2_deg(unit="rad")"direction of the acceleration in degree unit";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
r=b+c*cos(theta);
r_dot=-c*sin(theta)*theta_dot;
r_ddot=-c*cos(theta)*theta_dot^2-c*sin(theta)*theta_ddot;

v={r_dot,r*theta_dot};
theta_1=atan(abs(v[1])/abs(v[2]));
theta_1_deg=Modelica.SIunits.Conversions.to_deg(theta_1);

a={r_ddot-r*theta_dot^2,r*theta_ddot+2*r_dot*theta_dot};
theta_2=atan(abs(a[1])/abs(a[2]));
theta_2_deg=Modelica.SIunits.Conversions.to_deg(theta_2);
/*The  answer may slightly vary due to  rounding off values*/
end Ex8_18;
