class Ex8_21
parameter Real r_AB[3](each unit="mm")={0,75,0}"radius vector of AB";
parameter Real r_CB[3](each unit="mm")={-300,125,0}"radius vector of CB";
parameter Real r_DC[3](each unit="mm")={-75,-100,0}"radius vector of DC";
parameter Real r_BM[3](each unit="mm")={150,-62.5,0}"radius vector of BM";

parameter Real w_CD[3](each unit="rad/s")={0,0,-8}"angular velocity of CD";
Real w_AB_k(unit="rad/s")"k-component of the angular velocity of AB";
Real w_AB[3](each unit="rad/s")"angular velocity of AB";
Real w_BC_k(unit="rad/s")"k-component of the angular velocity of BC";
Real w_BC[3](each unit="rad/s")"angular velocity of BC";

Real v_B_L[3](each unit="mm/s")"left hand side of relative velocity equaion of B and C";
Real v_B_R[3](each unit="mm/s")"right hand side of relative velocity equaion of B and C";
Real v_M[3](each unit="mm/s")"relative velocity equaion of M";
Real theta(unit="rad")"direction of the velocity of M in radian unit";
Real theta_deg(unit="deg")"direction of the velocity of M in degree unit";
equation
w_AB={0,0,w_AB_k};
w_BC={0,0,w_BC_k};
v_B_L=cross(w_AB,r_AB);
v_B_R=cross(w_CD,r_DC)+cross(w_BC,r_CB);
v_B_L[1]=v_B_R[1];
v_B_L[2]=v_B_R[2];
v_M=cross(w_AB,r_AB)+cross(w_BC,r_BM);
theta=atan(v_M[2]/abs(v_M[1]));
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);
end Ex8_21;
