class Ex8_28
/*Alternative Solution*/
parameter Real r_AB[3](each unit="mm")={0,75,0}"radius vector of AB";
parameter Real r_BC[3](each unit="mm")={300,-125,0}"radius vector of CB";
parameter Real r_CD[3](each unit="mm")={-75,-100,0}"radius vector of DC";

parameter Real w_AB[3](each unit="rad/s")={0,0,14}"angular velocity of AB";
parameter Real w_BC[3](each unit="rad/s")={0,0,2}"angular velocity of BC";
parameter Real w_CD[3](each unit="rad/s")={0,0,-8}"angular velocity of CD";

Real alpha_AB[3](each unit="rad/s^2")={0,0,-30}"angular acceleration of AB";
Real alpha_BC_k(unit="rad/s^2")"k-component of the angular acceleration of BC";
Real alpha_BC[3](each unit="rad/s^2")"angular acceleration of BC";
Real alpha_CD_k(unit="rad/s^2")"k-component of the angular acceleration of CD";
Real alpha_CD[3](each unit="rad/s^2")"angular acceleration of CD";

Real a_C_L[3](each unit="mm/s^2")"left hand side of relative acceleration equaion of B and C";
Real a_C_R[3](each unit="mm/s^2")"right hand side of relative velocity equaion of B and C";
Real a_C[3](each unit="mm/s^2")"acceleration equaion of C";
Real a_C_mag(unit="mm/s^2")"magnitude of the acceleration equaion of C";

Real theta(unit="rad")"direction of the acceleration of C in radian unit";
Real theta_deg(unit="deg")"direction of the velocity of C in degree unit";
equation
alpha_BC={0,0,alpha_BC_k};
alpha_CD={0,0,alpha_CD_k};

a_C_L=cross(alpha_CD,r_CD)+cross(w_CD,cross(w_CD,r_CD));
a_C_R=cross(alpha_AB,r_AB)-(Modelica.Math.Vectors.norm(w_AB))^2*r_AB+cross(alpha_BC,r_BC)-    (Modelica.Math.Vectors.norm(w_BC))^2*r_BC;

a_C_L[1]=a_C_R[1];
a_C_L[2]=a_C_R[2];
a_C=a_C_L;
a_C_mag=Modelica.Math.Vectors.norm(a_C);
theta=atan(abs(a_C[2])/abs(a_C[1]));
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);
/*The  answer may slightly vary due to  rounding off values*/
end Ex8_28;
