class Ex9_11
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=50"mass of the wheel";
parameter Real k(unit="m")=400/1000"radius of gyration";
parameter Real d(unit="m")=1"diameter of the wheel";
parameter Real P_1(unit="N")=200"applied force at center of the wheel";
parameter Real P_2(unit="N")=150"applied force at the top of the wheel";
parameter Real mu=0.2"coefficient of friction";
Real I_Gz(unit="kg.m^2")"moment of inertia";
Real N(unit="N")"normal force";

/*system without considering the maximum friction*/
Real F_1(unit="N")"required friction force";
Real a_Gx_1(unit="m/s^2")"acceleration of the wheel";
Real alpha_1(unit="rad/s^2")"angular acceleration";

/*system considering the maximum friction*/
Real F_2(unit="N")"required friction force";
Real a_Gx_2(unit="m/s^2")"acceleration of the wheel";
Real alpha_2(unit="rad/s^2")"angular acceleration";

equation
/*system equation without considering the maximum friction*/
I_Gz=m*k^2;
P_1-P_2-F_1=m*a_Gx_1;
m*g-N=0;
(d/2)*F_1-(d/2)*P_2=I_Gz*alpha_1;
a_Gx_1=(d/2)*alpha_1;

/*system equation considering the maximum friction*/
F_2=mu*N;
P_1-P_2-F_2=m*a_Gx_2;
(d/2)*F_2-(d/2)*P_2=I_Gz*alpha_2;
end Ex9_11;
