class Ex14_17
parameter Real pi=Modelica.Constants.pi;
parameter Real R(unit="ohms")=2"resistance of the circuit";
parameter Real L(unit="H")=0.0191"inductance of the circuit";
parameter Real C(unit="microfarads")=2"capacitance of the circuit";
parameter Real f(unit="cycles/s")=500"frequency of the voltage";
Real X_L(unit="ohms")"inductive reactance of the circuit";
Real X_C(unit="ohms")"capacitive reactance of the circuit";
Real X(unit="ohms")"reactance of the circuit";
Real Z(unit="ohms")"impedence of the circuit";
Real C_b(unit="microfarads")"required capacitance for resonance";
Real dC_b(unit="microfarads")"extra required capacitance for resonance";
Real Z_c(unit="ohms")"impedence of the circuit for case c";
equation
X_L=2*pi*f*L;
X_C=10^6/(2*pi*f*C);
X=X_L-X_C;
Z=sqrt(R^2+X^2);
X_L=10^6/(2*pi*f*C_b);
dC_b=C_b-C;
Z_c=sqrt(R^2+0);
end Ex14_17;
