class Ex15_1
parameter Real l(unit="inch")=2"length of the filament";
parameter Real d(unit="inch")=0.0020"diameter of the filament";
parameter Real T(unit="K")=2200"temperature of the filament";
parameter Real A=60.2"constant";
parameter Real K=52600"constant";
Real Area(unit="cm^2")"cross sectional area";
Real i_s(unit="mA/cm^2")"saturation current";
Real i(unit="mA")"current through the tube";
equation
i_s=((A*T^2)/2.718^(K/T))*10^3;
Area=2*3.14*0.002*2.54^2;
i=Area*i_s;
/*The  answer may slightly vary due to  rounding off values*/
end Ex15_1;
