class Ex16_11
parameter Real l_fg(unit="m")=0.6*10^(-2)"thickness of the flint glass sheet";
parameter Real l_e(unit="m")=0.15*10^(-2)"thickness of the ebonite sheet";
parameter Real A(unit="m^2")=80*10^(-4)"cross sectional area";
parameter Real E(unit="V")=10000"applied voltage";
parameter Real epsilon_0=8.85*10^(-12)"dielectric constant of free space";
parameter Real epsilon_s_fg=9.9"specefic dielectric constant of the flint glass sheet";
parameter Real epsilon_s_e=2.7"specefic dielectric constant of the ebonite sheet";
Real S_fg"elastance of the flint glass";
Real S_e"elastance of the ebonite";
Real S"total elastance";
Real C(unit="F")"total capacitance";
Real phi(unit="C")"total flux";
Real D(unit="C/m^2")"flux density";
Real eta_fg(unit="V/m")"electric pressure on flint glass";
Real eta_e(unit="V/m")"electric pressure on ebonite";
equation
S_fg=(l_fg/A)*(1/(epsilon_0*epsilon_s_fg));
S_e=(l_e/A)*(1/(epsilon_0*epsilon_s_e));
S=S_fg+S_e;
C=1/S;
phi=C*E;
D=phi/A;
eta_fg=D/(epsilon_0*epsilon_s_fg);
eta_e=D/(epsilon_0*epsilon_s_e);
/*The  answer may slightly vary due to  rounding off values*/
end Ex16_11;
