class Ex16_7
parameter Real l_gl(unit="m")=0.25*10^(-2)"thickness of the glass sheet";
parameter Real l_gu(unit="m")=0.35*10^(-2)"thickness of the gutta percha sheet";
parameter Real A(unit="m^2")=100*10^(-4)"cross sectional area";
parameter Real epsilon_0=8.85*10^(-12)"dielectric constant of free space";
parameter Real epsilon_s_gl=9.9"specefic dielectric constant of the glass sheet";
parameter Real epsilon_s_gu=4.1"specefic dielectric constant of the gutta percha sheet";
Real S_gl"elastance of the glass";
Real S_gu"elastance of the gutta percha";
Real S"elastance of the series combination";
Real C(unit="F")"capacitance of the condenser";
equation
S_gl=(l_gl/A)*(1/(epsilon_0*epsilon_s_gl));
S_gu=(l_gu/A)*(1/(epsilon_0*epsilon_s_gu));
S=S_gl+S_gu;
C=1/S;
end Ex16_7;
