class Ex6_18
parameter Real w_sheet(unit="pounds")=42"weight of the sheet steel";
parameter Real f(unit="cycle")=30"supplied cycle";
parameter Real B(unit="lines/inch^2")=65000"flux density";
parameter Real rho(unit="pounds/inch^3")=0.283"density of the steel sheet";
Real P_cics(unit="W")"loss per cubic inch per cycle per second";
Real P_ci30cs(unit="W")"loss per cubic inch for 30 cycle per second";
Real v(unit="inch^3")"volume of the core";
Real P(unit="W")"loss in core";
equation
P_cics=(0.91*B^1.6)/10^10;
P_ci30cs=P_cics*f;
v=w_sheet/rho;
P=v*P_ci30cs;
/*The  answer may slightly vary due to  rounding off values*/
end Ex6_18;
