model Ex10_3

parameter Real d1(unit="inch")=1/32"distance between plats";
parameter Real inch2m(unit="inch")=39.37;
parameter Real l(unit="inch")=2"length";
parameter Real w(unit="inch")=2"length";
parameter Real epsilon_0(unit=" F⋅m−1")=8.85*10^(-12);
parameter Real epsilon_r=1;
parameter Real V(unit="V")=48"Voltage";

Real C(unit="pF")"capacitance";
Real d(unit="mm")"distance between plats of capacitot";
Real A1(unit="inch^2")"Area in inch";
Real A(unit="m^2")"Area in meter";
Real E(unit="kV/m")"Electric field";
Real Q(unit="nC")"Charge on the plates";

equation

d=(d1/inch2m)*1000;
A1=w*l;
A=A1/(inch2m*inch2m);
C=(epsilon_0*epsilon_r*A/d)/(10^(-15));
E=V/d;
Q=C*V/1000;

end Ex10_3;