model Ex11_1

parameter Real pi=Modelica.Constants.pi;
parameter Real d1(unit="inch")=1/4"distance ";
parameter Real inch2m(unit="inch")=39.37;
parameter Real l1(unit="inch")=1"length";
parameter Real N(unit="turns")=100"Number of turns";
parameter Real mu_0(unit=" H/m")=4*pi*10^(-7);
parameter Real mu_r1=1;
parameter Real mu_r2=2000;

Real d(unit="mm")"distance";
Real l(unit="mm")"Length in mm";
Real A(unit="micro meter^2")"Area";
Real La(unit="micro henry")"Inductance";
Real Lb(unit="millihenry")"Inductance";

equation

d=(d1/inch2m)/10^(-3);
A=((pi*d^2)/4);
l=(l1/inch2m)/10^(-3);
La=(mu_0*mu_r1*(N^2)*A)*1000/l;
Lb=mu_r2*La*10^(-3);

end Ex11_1;