model Ex20_2

parameter Real Vm(unit="V")=12"Voltage";
parameter Real XL(unit="ohm")=4;
parameter Real alpha(unit="deg")=45"angle";
parameter Real w1(unit="rad/s")=200"angular velocity";
parameter Real D2R=Modelica.Constants.D2R;

Real Im(unit="A")" Max current";
Real VL(unit="V")"Voltage";
Real iL(unit="A")"Current";
Real PL(unit="W")"instantaneous Power";
Real P(unit="W")"Power";
Real WL(unit="mJ")"energy stored";

equation

Im=Vm/XL;
PL=VL*iL;
VL=Vm*sin(alpha*D2R);
iL=Im*sin(alpha*D2R-90*D2R);
P=(Vm*Im)/2;
WL=((Vm*Im)/(2*w1))*1000;


end Ex20_2;