model Ex21_2

parameter Real pi=Modelica.Constants.pi;
parameter Real fs(unit="Hz")=4000"Frequency";
parameter Real BW(unit="Hz")=400"Band width";
parameter Real R(unit="ohm")=10"Resistance";

Real Qs;
Real XL(unit="ohm")"at resonance";
Real XC(unit="ohm")"at resonance";
Real L(unit="mH")"inductance";
Real C(unit="nF")"Capacitance";

equation

Qs=fs/BW;
XL=Qs*R;
XC=XL;
XL=2*pi*fs*L/1000;
XC=10^9/(2*pi*fs*C);

end Ex21_2;