model Ex21_9

parameter Real pi=Modelica.Constants.pi;
Real fs(unit="Hz")"Frequency";
Real fp(unit="Hz")"Frequency";
Real BW(unit="Hz")"Band width";
parameter Real Rl(unit="ohm")=100"Resistance";
parameter Real Rs(unit="ohm")=50000"Resistance";
parameter Real L(unit="H")=5*10^(-3)"inductance";
parameter Real C(unit="F")=50*10^(-12)"Capacitance";
parameter Real I(unit="A")=2*10^(-3);

Real Ql;
Real XL(unit="ohm")"at resonance";
Real Rp(unit="ohm");
Real Qp;
Real Vp(unit="V")"Voltage";

equation

fs=1/(2*pi*sqrt(L*C));
fp=fs;
XL=2*pi*fs*L;
Ql=XL/Rl;
Rp=(Ql^2)*Rl;
Qp=((Rp*Rs)/(Rp+Rs))/XL;
BW=fp/Qp;
Vp=I*((Rp*Rs)/(Rs+Rp));


end Ex21_9;