model Ex23_1

parameter Real Lp(unit="H")=200*10^(-3)"inductance";
parameter Real Ls(unit="H")=800*10^(-3)"inductance";
parameter Real Np=50"Number of turns in primary coil";
parameter Real Ns=100"Number of turns in secondary coil";
parameter Real k=0.6;
parameter Real dphip_dt(unit="Wb/s")=450*10^(-3);
parameter Real dip_dt(unit="A/s")=200;

Real M(unit="H")"mutual Inductance";
Real ep_b(unit="V")"=ep induced voltage";
Real es_c(unit="V")"=es induced voltage";
Real ep_d(unit="V")"=ep induced voltage";
Real es_d(unit="V")"=es induced voltage";

equation

M=k*sqrt(Lp*Ls);
ep_b=Np*dphip_dt;
es_c=k*Ns*dphip_dt;
ep_d=Lp*dip_dt;
es_d=M*dip_dt;

end Ex23_1;