model Ex24_5

parameter Real V_phi(unit="V")=100;
parameter Real I_phi(unit="A")=20;
parameter Real thita(unit="deg")=53.13;
parameter Real D2R=Modelica.Constants.D2R;
parameter Real R_phi(unit="ohm")=3;
parameter Real X_phi(unit="ohm")=4;
parameter Real VR(unit="V")=60;

Real P_phi1(unit="W")"average power to phase";
Real P_phi2(unit="W")"average power to phase";
Real P_phi3(unit="W")"average power to phase";
Real PT(unit="W")"Total power";
Real Q_phi(unit="VAR")"reactive power";
Real QT(unit="VAR")"Total reactive power";
Real S_phi(unit="VA")"apparent power";
Real ST(unit="VA")"Total apparent power";
Real Fp(unit="lagging")"power factor";


equation

P_phi1=V_phi*I_phi*cos(thita*D2R);
P_phi2=(I_phi^2)*R_phi;
P_phi3=(VR^2)/R_phi;
PT=3*P_phi1;
Q_phi=V_phi*I_phi*sin(thita*D2R);
QT=3*Q_phi;
S_phi=V_phi*I_phi;
ST=3*S_phi;
Fp=PT/ST;

end Ex24_5;