package Ex24_9

model Ex24_9_a
parameter Real M_ECA(unit="V")=200"magnitude of ECA";
parameter Real M_EBC(unit="V")=200"magnitude of EBC";
parameter Real M_EAB(unit="V")=200"magnitude of EAB";
parameter Real M_Z1(unit="ohm")=166"magnitude of Z1";
parameter Real M_Z2(unit="ohm")=200"magnitude of Z2";
parameter Real M_Z3(unit="ohm")=200"magnitude of Z3";
parameter Real D2R=Modelica.Constants.D2R;
parameter Real R2D=Modelica.Constants.D2R;
parameter Complex j(re=0,im=1);

parameter Real phi_ECA(unit="deg")=120"angle of ECA";
parameter Real phi_EBC(unit="deg")=-120"angle of EBC";
parameter Real phi_EAB(unit="deg")=0"angle of EBC";
parameter Real phi_Z1(unit="deg")=-90"angle of Z1";
parameter Real phi_Z2(unit="deg")=0"angle of Z2";
parameter Real phi_Z3(unit="deg")=0"angle of Z3";


Real M_ECA_Z2(unit="V.ohm")"Magnitude of ECA.Z2";
Real M_EAB_Z3(unit="V.ohm")"Magnitude of ECA.Z2";
Real M_EBC_Z1(unit="V.ohm")"Magnitude of EBC.Z1";
Real M_Z1_Z2(unit="ohm^2")"Magnitude of Z1.Z2";
Real M_Z1_Z3(unit="ohm^2")"Magnitude of Z1.Z3";
Real M_Z2_Z3(unit="ohm^2")"Magnitude of Z2_Z3";
Real phi_ECA_Z2(unit="deg")"angle of ECA.Z2";
Real phi_EAB_Z3(unit="deg")"angle of ECA.Z2";
Real phi_EBC_Z1(unit="deg")"angle of EBC.Z1";
Real phi_Z1_Z2(unit="deg")"angle of Z1.Z2";
Real phi_Z1_Z3(unit="deg")"angle of Z1.Z3";
Real phi_Z2_Z3(unit="deg")"angle of Z2_Z3";
Complex A(re(unit="V"),im(unit="V"));
Complex B(re(unit="ohm"),im(unit="ohm"));
Real M_A(unit="V");
Real M_B(unit="ohm");
Real phi_A(unit="deg");
Real phi_B(unit="deg");
Real M_Icn(unit="A")"Magnitude of Icn";
Real phi_Icn(unit="deg")"Angle of Icn";
Complex A1(re(unit="V"),im(unit="V"));
Complex B1(re(unit="ohm"),im(unit="ohm"));
Real M_A1(unit="V");
Real M_B1(unit="ohm");
Real phi_A1(unit="deg");
Real phi_B1(unit="deg");
Real M_Ibn(unit="A")"Magnitude of Ibn";
Real phi_Ibn(unit="deg")"Angle of Ibn";

equation

(M_ECA_Z2,phi_ECA_Z2)=PolarOperation(M_ECA,M_Z2,phi_ECA,phi_Z2,2);
(M_EAB_Z3,phi_EAB_Z3)=PolarOperation(M_EAB,M_Z3,phi_EAB,phi_Z3,2);
(M_EBC_Z1,phi_EBC_Z1)=PolarOperation(M_EBC,M_Z1,phi_EBC,phi_Z1,2);
(M_Z1_Z2,phi_Z1_Z2)=PolarOperation(M_Z1,M_Z2,phi_Z1,phi_Z2,2);
(M_Z1_Z3,phi_Z1_Z3)=PolarOperation(M_Z1,M_Z3,phi_Z1,phi_Z3,2);
(M_Z2_Z3,phi_Z2_Z3)=PolarOperation(M_Z2,M_Z3,phi_Z2,phi_Z3,2);
A=M_ECA_Z2*cos(phi_ECA_Z2*D2R)+j*M_ECA_Z2*sin(phi_ECA_Z2*D2R)+M_EBC_Z1*cos(phi_EBC_Z1*D2R)+j*M_EBC_Z1*sin(phi_EBC_Z1*D2R);
B=M_Z1_Z2*cos(phi_Z1_Z2*D2R)+j*M_Z1_Z2*sin(phi_Z1_Z2*D2R)+M_Z1_Z3*cos(phi_Z1_Z3*D2R)+j*M_Z1_Z3*sin(phi_Z1_Z3*D2R)+M_Z2_Z3*cos(phi_Z2_Z3*D2R)+j*M_Z2_Z3*sin(phi_Z2_Z3*D2R);
M_A=sqrt(A.re^2+A.im^2);
M_B=sqrt(B.re^2+B.im^2);
phi_A=atan(A.im/A.re)/D2R;
phi_B=atan(B.im/B.re)/D2R;
(M_Icn,phi_Icn)=PolarOperation(M_A,M_B,phi_A,phi_B,1);
A1=-M_EAB_Z3*cos(phi_EAB_Z3*D2R)-j*M_EAB_Z3*sin(phi_EAB_Z3*D2R)-M_EBC_Z1*cos(phi_EBC_Z1*D2R)-j*M_EBC_Z1*sin(phi_EBC_Z1*D2R);
B1=M_Z1_Z2*cos(phi_Z1_Z2*D2R)+j*M_Z1_Z2*sin(phi_Z1_Z2*D2R)+M_Z1_Z3*cos(phi_Z1_Z3*D2R)+j*M_Z1_Z3*sin(phi_Z1_Z3*D2R)+M_Z2_Z3*cos(phi_Z2_Z3*D2R)+j*M_Z2_Z3*sin(phi_Z2_Z3*D2R);
M_A1=sqrt(A1.re^2+A1.im^2);
M_B1=sqrt(B1.re^2+B1.im^2);
phi_A1=180+atan(A1.im/A1.re)/D2R;
phi_B1=atan(B1.im/B1.re)/D2R;
(M_Ibn,phi_Ibn)=PolarOperation(M_A1,M_B1,phi_A1,phi_B1,1);

end Ex24_9_a;

function PolarOperation

input Real M1;
input Real M2;
input Real phi1;
input Real phi2;
input Real a;

output Real M;
output Real phi;

algorithm

//division of complex numbers in polar form 
if a==1 then
M:=M1/M2;
phi:=phi1-phi2;
if phi<=-180 then
phi:=phi+180;
end if;

//multiplication of complex number in polar form

elseif a==2 then
M:=M1*M2;
phi:=phi1+phi2;
if phi<=-180 then
phi:=phi+180;
end if;



end if;



end PolarOperation;

end Ex24_9;