model Ex25_6

parameter Real v1(unit="mV")=8"peak Value";
parameter Real vb(unit="mV")=2;
parameter Real t1(unit="micro second")=4;
parameter Real t2(unit="micro second")=6;
parameter Real t3(unit="micro second")=2;
parameter Real t4(unit="micro second")=12;

Real Vav(unit="mV")"avarage voltage";
Real area_under_curve(unit="n.V.s")"area under curve";
Real G(unit="mV");
Real T(unit="micro sec")"period";
Real tp(unit="micro sec")"pulse width";
Real Duty_cycle"Duty cycle";

equation

T=t4-t3;
area_under_curve=v1*t1+vb*t2;
G=area_under_curve/T;
tp=t2-t3;
Duty_cycle=(tp/T);
Vav=(Duty_cycle)*(v1)+(1-Duty_cycle)*vb;

end Ex25_6;