model Ex6_15

parameter Real R1(unit="kohm")=1.6"resistance";
parameter Real R2(unit="kohm")=20"resistance";
parameter Real R3(unit="kohm")=56"resistance";
parameter Real E(unit="V")=28"Source voltage";

Real V1(unit="V")"voltage";
Real V2(unit="V")"voltage";
Real V3(unit="V")"voltage";
Real Is(unit="mA")"Current";
Real I1(unit="mA")"Current";
Real I2(unit="mA")"Current";
Real I3(unit="mA")"Current";
Real RT(unit="kohm")"total resistance";
Real PE(unit="mW")"Power delivered by source";
Real P1(unit="mW")"Power absorbed by R1";
Real P2(unit="mW")"Power absorbed by R2";
Real P3(unit="mW")"Power absorbed by R3";

equation

RT=1/((1/R1)+(1/R2)+(1/R3));
Is=E/RT;
V1=E;
V2=E;
V3=E;
I1=V1/R1;
I2=V2/R2;
I3=V3/R3;
PE=E*Is;
P1=V1*I1;
P2=V2*I2;
P3=V3*I3;

end Ex6_15;