model Ex9_11

parameter Real R1(unit="ohm")=6"Resistance";
parameter Real R2(unit="ohm")=4"Resistance";
parameter Real R3(unit="ohm")=12"Resistance";
parameter Real Ra(unit="ohm")=8"Resistance";
parameter Real E1(unit="V")=18"Source Voltage";
parameter Real E2(unit="V")=16"Source Voltage";
parameter Real I(unit="A")=2"Current";

Real RTh(unit="ohm")"Resistance";
Real ETh(unit="V")"Source Voltage";
Real ETh_das(unit="V")"Source Voltage";
Real ETh_ddas(unit="V")"Source Voltage";
Real I_das(unit="A")"Current";
Real Va(unit="V")"Voltage";

equation

RTh=(R3*(R1+R2))/(R1+R2+R3);
ETh_das=(R3*E1)/(R1+R2+R3);
I_das=(R2*I)/(R1+R2+R3);
ETh_ddas=-I_das*R3;
ETh=ETh_das+ETh_ddas;
Va=(Ra*(ETh+E2))/(RTh+Ra);

end Ex9_11;