model Ex12_1

parameter Real pi=Modelica.Constants.pi;
parameter Real A(unit="m^2")=2*10^(-3)"Area";
parameter Real shi(unit="Wb")=4*10^(-4);
parameter Real l(unit="m")=0.16"length";
parameter Real N(unit="turns")=400"Number of turns";
parameter Real H(unit="At/m")=170"Magnetizing force";
parameter Real mu_0(unit=" H/m")=4*pi*10^(-7);

Real B(unit="T")"Flux density";
Real I(unit="mA")"Current";
Real mu(unit="Wb/Am")"Permeability of the material";
Real mu_r"Relative permeability";

equation

B=shi/A;
N*I=1000*H*l;
mu=B/H;
mu_r=mu/mu_0;
// Answer may be slightly varied due to round off.
end Ex12_1;