model Ex12_2

parameter Real lab(unit="in")=4;
parameter Real lcd(unit="in")=4;
parameter Real lef(unit="in")=4;
parameter Real lfa(unit="in")=4;
parameter Real lbc(unit="in")=0.5;
parameter Real lde(unit="in")=0.5;
parameter Real Area(unit="in^2")=1;
parameter Real inch2m(unit="inch")=39.37;
parameter Real N(unit="turns")=50"Number of turns";
parameter Real Hefab(unit="At/m")=70"Magnetizing force";
parameter Real Hbcde(unit="At/m")=1600"Magnetizing force";
parameter Real shi(unit="Wb")=3.5*10^(-4);


Real B(unit="T")"Flux density";
Real I(unit="A")"Current";
Real A(unit="m^2")"Area in meter";
Real lefab(unit="m")"Length in meter";
Real lbcde(unit="m")"Length in meter";

equation

lefab=(lef+lfa+lab)/inch2m;
lbcde=(lbc+lcd+lde)/inch2m;
A=Area/(inch2m^2);
B=shi/A;
N*I=Hefab*lefab+Hbcde*lbcde;


end Ex12_2;