model Ex13_9

parameter Real V(unit="V")=4"Voltage";
parameter Real w(unit="rad/s")=377"angular velocity";
parameter Real Em(unit="V")=10;
parameter Real D2R=Modelica.Constants.D2R;
parameter Real R2D=Modelica.Constants.R2D;
Real alpha1_rad(unit="rad");
Real alpha2_rad(unit="rad");
Real alpha1(unit="deg");
Real alpha2(unit="deg");
Real t1(unit="ms")"time at which the magnitude is attained";
Real t2(unit="ms")"time at which the magnitude is attained";

equation

V=Em*sin(alpha1_rad);
alpha1=alpha1_rad*R2D;
alpha2=180-alpha1;
alpha2_rad=alpha2*D2R;
t1=(alpha1_rad/w)*1000;
t2=(alpha2_rad/w)*1000;


end Ex13_9;